<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';

if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header("Location: dashboard.php?error=access_denied");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';

$usuarios = $pdo->query("SELECT * FROM users ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<main class="flex-1 overflow-y-auto p-6 md:p-8 relative">
    <div class="max-w-6xl mx-auto relative z-10">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase">Usuarios del Sistema</h1>
                <p class="text-sm text-gray-500">Control de accesos para JFD Importaciones.</p>
            </div>
            <a href="nuevo_usuario.php" class="bg-brand-red hover:bg-brand-red_hover text-white px-6 py-3 rounded-lg font-bold uppercase tracking-wider shadow-lg transition-all flex items-center gap-2">
                <i class="ri-user-settings-line text-xl"></i> Nuevo Usuario
            </a>
        </div>

        <div class="mb-4 relative">
            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="ri-search-line text-gray-400"></i>
            </div>
            <input type="text" id="buscador-usuarios" placeholder="Buscar por nombre, email, rol o teléfono..." 
                   class="w-full md:w-1/3 pl-10 pr-4 py-2 border border-gray-200 dark:border-white/10 rounded-lg bg-white dark:bg-brand-dark text-gray-900 dark:text-white focus:outline-none focus:border-brand-red dark:focus:border-brand-red transition-colors shadow-sm">
        </div>

        <div class="bg-white dark:bg-brand-dark rounded-xl shadow-sm border border-gray-100 dark:border-white/5 overflow-hidden">
            <table class="w-full text-left text-sm" id="tabla-usuarios">
                <thead class="bg-gray-50 dark:bg-white/5 text-xs uppercase font-bold text-gray-500 dark:text-gray-300">
                    <tr>
                        <th class="px-6 py-4">N°</th> 
                        <th class="px-6 py-4">Nombre</th>
                        <th class="px-6 py-4">Email / Rol</th>
                        <th class="px-6 py-4">Teléfono</th>
                        <th class="px-6 py-4 text-right">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 dark:divide-white/5">
                    <?php 
                    $count = 1; 
                    foreach($usuarios as $u): 
                    ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-white/5 transition-colors fila-usuario">
                        <td class="px-6 py-4 font-mono font-bold text-gray-400">
                            <?php echo str_pad($count++, 2, "0", STR_PAD_LEFT); ?>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded bg-brand-red text-white flex items-center justify-center font-bold">
                                    <?php echo strtoupper(substr($u['full_name'], 0, 1)); ?>
                                </div>
                                <span class="font-bold text-gray-900 dark:text-white"><?php echo $u['full_name']; ?></span>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-gray-900 dark:text-gray-300"><?php echo $u['email']; ?></div>
                            <span class="text-[10px] px-2 py-0.5 rounded font-black uppercase <?php echo $u['role'] == 'admin' ? 'bg-amber-100 text-amber-700' : 'bg-blue-100 text-blue-700'; ?>">
                            <?php echo $u['role'] == 'admin' ? 'Administrador' : 'Editor'; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 text-gray-500">
                            <?php echo $u['phone'] ?: '<span class="opacity-30">N/A</span>'; ?>
                        </td>
                        <td class="px-6 py-4 text-right space-x-2">
                            <a href="editar_usuario.php?id=<?php echo $u['id']; ?>" class="inline-flex items-center justify-center w-8 h-8 rounded bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white transition-all">
                                <i class="ri-pencil-line"></i>
                            </a>
                            <form action="eliminar_usuario.php" method="POST" id="form-delete-<?php echo $u['id']; ?>" class="inline-block">
                                <input type="hidden" name="id" value="<?php echo $u['id']; ?>">
                                <button type="button" onclick="confirmDelete(<?php echo $u['id']; ?>, '<?php echo $u['full_name']; ?>')" class="inline-flex items-center justify-center w-8 h-8 rounded bg-red-50 text-red-600 hover:bg-red-600 hover:text-white transition-all">
                                    <i class="ri-delete-bin-line"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<script>
// FUNCIÓN PARA ELIMINAR USUARIO (Mantenida intacta)
function confirmDelete(id, name) {
    const isDarkMode = document.documentElement.classList.contains('dark');
    Swal.fire({
        title: '<span class="font-display font-black uppercase">¿ELIMINAR ACCESO?</span>',
        html: `Estás revocando el acceso a <b>${name}</b>.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#D90429',
        cancelButtonColor: isDarkMode ? '#262626' : '#9ca3af',
        confirmButtonText: 'SÍ, ELIMINAR',
        cancelButtonText: 'CANCELAR',
        background: isDarkMode ? '#121212' : '#ffffff',
        color: isDarkMode ? '#ffffff' : '#000000'
    }).then((result) => { 
        if (result.isConfirmed) {
            document.getElementById('form-delete-' + id).submit(); 
        }
    });
}

// NUEVA FUNCIÓN PARA EL BUSCADOR DE USUARIOS
document.addEventListener('DOMContentLoaded', function() {
    const buscador = document.getElementById('buscador-usuarios');
    const filas = document.querySelectorAll('.fila-usuario');

    buscador.addEventListener('keyup', function() {
        const textoBusqueda = this.value.toLowerCase();

        filas.forEach(fila => {
            // Extrae todo el texto de la fila (nombre, correo, rol, teléfono)
            const contenidoFila = fila.textContent.toLowerCase();
            
            if (contenidoFila.includes(textoBusqueda)) {
                fila.style.display = ''; // Muestra si hay coincidencia
            } else {
                fila.style.display = 'none'; // Oculta si no coincide
            }
        });
    });
});
</script>

<?php require_once 'includes/footer.php'; ?>